/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.Joiner;
import com.google.common.math.DoubleMath;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.objects.entity.EntitySeatOn;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.dries007.tfc.objects.entity.animal.EntityCowTFC;
import net.dries007.tfc.objects.entity.animal.EntityDonkeyTFC;
import net.dries007.tfc.objects.entity.animal.EntityHorseTFC;
import net.dries007.tfc.objects.entity.animal.EntityLlamaTFC;
import net.dries007.tfc.objects.entity.animal.EntityMuleTFC;
import net.dries007.tfc.objects.entity.animal.EntityOcelotTFC;
import net.dries007.tfc.objects.entity.animal.EntityParrotTFC;
import net.dries007.tfc.objects.entity.animal.EntityPigTFC;
import net.dries007.tfc.objects.entity.animal.EntityPolarBearTFC;
import net.dries007.tfc.objects.entity.animal.EntityRabbitTFC;
import net.dries007.tfc.objects.entity.animal.EntitySheepTFC;
import net.dries007.tfc.objects.entity.animal.EntityWolfTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Helpers {
    private static final Joiner JOINER_DOT = Joiner.on((char)'.');
    private static final boolean JEI = Loader.isModLoaded((String)"jei");
    private static final Map<Class<? extends Entity>, Class<? extends Entity>> VANILLA_REPLACEMENTS;
    private static final Set<Class<? extends Entity>> PREVENT_ON_SURFACE;

    public static boolean isJEIEnabled() {
        return JEI;
    }

    public static boolean isVanillaAnimal(Entity entity) {
        return VANILLA_REPLACEMENTS.get(entity.getClass()) != null;
    }

    @Nullable
    public static Entity getTFCReplacement(Entity entity) {
        Class<? extends Entity> animalClass = VANILLA_REPLACEMENTS.get(entity.getClass());
        if (animalClass != null) {
            try {
                return animalClass.getConstructor(World.class).newInstance(entity.field_70170_p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean shouldPreventOnSurface(Entity entity) {
        return PREVENT_ON_SURFACE.contains(entity.getClass()) || entity.isCreatureType(EnumCreatureType.MONSTER, false);
    }

    public static void sitOnBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityLiving creature, double yOffset) {
        if (!world.field_72995_K && !world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            EntitySeatOn seat = new EntitySeatOn(world, pos, yOffset);
            world.func_72838_d((Entity)seat);
            creature.func_184220_m((Entity)seat);
        }
    }

    @Nullable
    public static Entity getSittingEntity(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K) {
            List seats = world.func_72872_a(EntitySeatOn.class, new AxisAlignedBB(pos).func_186662_g(1.0));
            for (EntitySeatOn seat : seats) {
                if (!pos.equals((Object)seat.getPos())) continue;
                return seat.getSittingEntity();
            }
        }
        return null;
    }

    @Nullable
    public static RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        Vec3d playerVec = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        float cosYaw = MathHelper.func_76134_b((float)(-playerIn.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-playerIn.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-playerIn.field_70125_A * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-playerIn.field_70125_A * ((float)Math.PI / 180)));
        double reachDistance = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d targetVec = playerVec.func_72441_c((double)(sinYaw * cosPitch) * reachDistance, (double)sinPitch * reachDistance, (double)(cosYaw * cosPitch) * reachDistance);
        return worldIn.func_147447_a(playerVec, targetVec, useLiquids, !useLiquids, false);
    }

    @Nullable
    public static RayTraceResult rayTrace(Entity entity, double blockReachDistance, float partialTicks) {
        Vec3d eyePosition = entity.func_174824_e(partialTicks);
        Vec3d lookVector = entity.func_70676_i(partialTicks);
        Vec3d rayTraceVector = eyePosition.func_72441_c(lookVector.field_72450_a * blockReachDistance, lookVector.field_72448_b * blockReachDistance, lookVector.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_147447_a(eyePosition, rayTraceVector, false, false, true);
    }

    public static boolean containsAnyOfCaseInsensitive(Collection<String> input, String ... items) {
        Set itemsSet = Arrays.stream(items).map(String::toLowerCase).collect(Collectors.toSet());
        return input.stream().map(String::toLowerCase).anyMatch(itemsSet::contains);
    }

    public static <T extends TileEntity> T getTE(IBlockAccess world, BlockPos pos, Class<T> aClass) {
        TileEntity te = world.func_175625_s(pos);
        if (!aClass.isInstance(te)) {
            return null;
        }
        return (T)te;
    }

    public static String getEnumName(Enum<?> anEnum) {
        return JOINER_DOT.join((Object)"tfc", (Object)"enum", new Object[]{anEnum.getDeclaringClass().getSimpleName(), anEnum}).toLowerCase();
    }

    public static String getTypeName(IForgeRegistryEntry<?> type) {
        return JOINER_DOT.join((Object)"tfc", (Object)"types", new Object[]{type.getRegistryType().getSimpleName(), type.getRegistryName().func_110623_a()}).toLowerCase();
    }

    public static boolean playerHasItemMatchingOre(InventoryPlayer playerInv, String ore) {
        for (ItemStack stack : playerInv.field_70462_a) {
            if (stack.func_190926_b() || !OreDictionaryHelper.doesStackMatchOre(stack, ore)) continue;
            return true;
        }
        for (ItemStack stack : playerInv.field_70460_b) {
            if (stack.func_190926_b() || !OreDictionaryHelper.doesStackMatchOre(stack, ore)) continue;
            return true;
        }
        for (ItemStack stack : playerInv.field_184439_c) {
            if (stack.func_190926_b() || !OreDictionaryHelper.doesStackMatchOre(stack, ore)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static ItemStack consumeItem(ItemStack stack, int amount) {
        if (stack.func_190916_E() <= amount) {
            return ItemStack.field_190927_a;
        }
        stack.func_190918_g(amount);
        return stack;
    }

    @Nonnull
    public static ItemStack consumeItem(ItemStack stack, EntityPlayer player, int amount) {
        return player.func_184812_l_() ? stack : Helpers.consumeItem(stack, amount);
    }

    public static void damageItem(ItemStack stack) {
        Helpers.damageItem(stack, 1);
    }

    public static void damageItem(ItemStack stack, int amount) {
        if (stack.func_96631_a(amount, Constants.RNG, null)) {
            stack.func_190918_g(1);
            stack.func_77964_b(0);
        }
    }

    public static void spawnItemStack(World world, BlockPos pos, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        world.func_72838_d((Entity)entityitem);
    }

    public static boolean canHangAt(World worldIn, BlockPos pos, EnumFacing facing) {
        return worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public static EnumFacing getASolidFacing(World worldIn, BlockPos pos, @Nullable EnumFacing preferredFacing, EnumFacing ... possibleSides) {
        return Helpers.getASolidFacing(worldIn, pos, preferredFacing, Arrays.asList(possibleSides));
    }

    public static EnumFacing getASolidFacing(World worldIn, BlockPos pos, @Nullable EnumFacing preferredFacing, Collection<EnumFacing> possibleSides) {
        if (preferredFacing != null && possibleSides.contains(preferredFacing) && Helpers.canHangAt(worldIn, pos, preferredFacing)) {
            return preferredFacing;
        }
        for (EnumFacing side : possibleSides) {
            if (side == null || !Helpers.canHangAt(worldIn, pos, side)) continue;
            return side;
        }
        return null;
    }

    public static void handleRightClickBlockPostEventWithCallbacks(PlayerInteractEvent.RightClickBlock event, @Nullable Supplier<EnumActionResult> onItemUseCallback) {
        boolean bypass;
        EnumFacing face;
        event.setCanceled(true);
        EnumActionResult result = EnumActionResult.PASS;
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        boolean hitX = false;
        boolean hitY = false;
        boolean hitZ = false;
        EnumFacing enumFacing = face = event.getFace() == null ? EnumFacing.UP : event.getFace();
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getHand(), face, (float)hitX, (float)hitY, (float)hitZ)) != EnumActionResult.PASS) {
            event.setCancellationResult(result);
            return;
        }
        boolean bl = bypass = event.getEntityPlayer().func_184614_ca().doesSneakBypassUse((IBlockAccess)event.getWorld(), event.getPos(), event.getEntityPlayer()) && event.getEntityPlayer().func_184592_cb().doesSneakBypassUse((IBlockAccess)event.getWorld(), event.getPos(), event.getEntityPlayer());
        if (!event.getEntityPlayer().func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState iblockstate = event.getWorld().func_180495_p(event.getPos());
            if (event.getUseBlock() != Event.Result.DENY && iblockstate.func_177230_c().func_180639_a(event.getWorld(), event.getPos(), iblockstate, event.getEntityPlayer(), event.getHand(), face, (float)hitX, (float)hitY, (float)hitZ)) {
                result = EnumActionResult.SUCCESS;
            }
        }
        if (stack.func_190926_b()) {
            event.setCancellationResult(EnumActionResult.PASS);
        } else if (event.getEntityPlayer().func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            event.setCancellationResult(EnumActionResult.PASS);
        } else {
            Block block;
            if (stack.func_77973_b() instanceof ItemBlock && !event.getEntityPlayer().func_189808_dh() && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
                event.setCancellationResult(EnumActionResult.FAIL);
                return;
            }
            if (event.getEntityPlayer().func_184812_l_()) {
                int j = stack.func_77960_j();
                int i = stack.func_190916_E();
                if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                    EnumActionResult enumactionresult = onItemUseCallback != null ? onItemUseCallback.get() : stack.func_179546_a(event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getHand(), face, (float)hitX, (float)hitY, (float)hitZ);
                    stack.func_77964_b(j);
                    stack.func_190920_e(i);
                    event.setCancellationResult(enumactionresult);
                } else {
                    event.setCancellationResult(result);
                }
            } else {
                if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                    ItemStack copyBeforeUse = stack.func_77946_l();
                    result = stack.func_179546_a(event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getHand(), event.getFace(), (float)hitX, (float)hitY, (float)hitZ);
                    if (stack.func_190926_b()) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)event.getEntityPlayer(), (ItemStack)copyBeforeUse, (EnumHand)event.getHand());
                    }
                }
                event.setCancellationResult(result);
            }
        }
    }

    public static void writeResourceLocation(ByteBuf buf, @Nullable ResourceLocation loc) {
        buf.writeBoolean(loc != null);
        if (loc != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)loc.toString());
        }
    }

    @Nullable
    public static ResourceLocation readResourceLocation(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        return null;
    }

    public static <T> List<T> listOf(T element) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(element);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }

    public static double getTPS(World world, int dimId) {
        if (world == null || world.func_73046_m() == null) {
            return -1.0;
        }
        double worldTickTime = DoubleMath.mean((long[])((long[])world.func_73046_m().worldTickTimes.get(dimId))) * 1.0E-6;
        return Math.min(1000.0 / worldTickTime, 20.0);
    }

    static {
        PREVENT_ON_SURFACE = new HashSet<Class<? extends Entity>>();
        PREVENT_ON_SURFACE.add(EntityZombieHorse.class);
        PREVENT_ON_SURFACE.add(EntitySkeletonHorse.class);
        VANILLA_REPLACEMENTS = new HashMap<Class<? extends Entity>, Class<? extends Entity>>();
        VANILLA_REPLACEMENTS.put(EntityCow.class, EntityCowTFC.class);
        VANILLA_REPLACEMENTS.put(EntitySheep.class, EntitySheepTFC.class);
        VANILLA_REPLACEMENTS.put(EntityPig.class, EntityPigTFC.class);
        VANILLA_REPLACEMENTS.put(EntityMule.class, EntityMuleTFC.class);
        VANILLA_REPLACEMENTS.put(EntityHorse.class, EntityHorseTFC.class);
        VANILLA_REPLACEMENTS.put(EntityDonkey.class, EntityDonkeyTFC.class);
        VANILLA_REPLACEMENTS.put(EntityChicken.class, EntityChickenTFC.class);
        VANILLA_REPLACEMENTS.put(EntityRabbit.class, EntityRabbitTFC.class);
        VANILLA_REPLACEMENTS.put(EntityWolf.class, EntityWolfTFC.class);
        VANILLA_REPLACEMENTS.put(EntityOcelot.class, EntityOcelotTFC.class);
        VANILLA_REPLACEMENTS.put(EntityPolarBear.class, EntityPolarBearTFC.class);
        VANILLA_REPLACEMENTS.put(EntityParrot.class, EntityParrotTFC.class);
        VANILLA_REPLACEMENTS.put(EntityLlama.class, EntityLlamaTFC.class);
    }
}

